/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.client;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.block.tile.DrawerTile;
import com.buuz135.functionalstorage.client.FunctionalStorageClientConfig;
import com.buuz135.functionalstorage.inventory.BigInventoryHandler;
import com.buuz135.functionalstorage.item.ConfigurationToolItem;
import com.buuz135.functionalstorage.util.MathUtils;
import com.buuz135.functionalstorage.util.NumberUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class DrawerRenderer
implements BlockEntityRenderer<DrawerTile> {
    public static void renderUpgrades(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, ControllableDrawerTile<?> tile) {
        float scale = 0.0625f;
        if (tile.getDrawerOptions().isActive(ConfigurationToolItem.ConfigurationAction.TOGGLE_UPGRADES)) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.031, (double)0.031f, 0.0295);
            for (int i = 0; i < tile.getStorageUpgrades().getSlots(); ++i) {
                ItemStack stack = tile.getStorageUpgrades().getStackInSlot(i);
                if (stack.m_41619_()) continue;
                matrixStack.m_85836_();
                matrixStack.m_85841_(scale, scale, scale);
                Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.NONE, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, 0);
                matrixStack.m_85849_();
                matrixStack.m_85837_((double)scale, 0.0, 0.0);
            }
            matrixStack.m_85849_();
        }
        if (tile.isVoid()) {
            matrixStack.m_85836_();
            matrixStack.m_166854_(MathUtils.createTransformMatrix(new Vector3f(0.969f, 0.031f, 0.0293125f), Vector3f.f_176763_, scale));
            Minecraft.m_91087_().m_91291_().m_174269_(new ItemStack((ItemLike)FunctionalStorage.VOID_UPGRADE.get()), ItemTransforms.TransformType.NONE, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, 0);
            matrixStack.m_85849_();
        }
    }

    public static void renderStack(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, ItemStack stack, int amount, float scale, ControllableDrawerTile.DrawerOptions options) {
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(stack, (Level)Minecraft.m_91087_().f_91073_, null, 0);
        if (model.m_7539_()) {
            float thickness = (float)FunctionalStorageClientConfig.DRAWER_RENDER_THICKNESS;
            matrixStack.m_166854_(MathUtils.createTransformMatrix(Vector3f.f_176763_, Vector3f.f_176763_, new Vector3f(0.75f, 0.75f, thickness)));
        } else {
            matrixStack.m_166854_(MathUtils.createTransformMatrix(Vector3f.f_176763_, Vector3f.f_176763_, 0.4f));
        }
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        if (options.isActive(ConfigurationToolItem.ConfigurationAction.TOGGLE_RENDER)) {
            Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, 0);
        }
        matrixStack.m_166854_(MathUtils.createTransformMatrix(Vector3f.f_176763_, new Vector3f(0.0f, 180.0f, 0.0f), 1.0f));
        if (!model.m_7539_()) {
            matrixStack.m_166854_(MathUtils.createTransformMatrix(Vector3f.f_176763_, Vector3f.f_176763_, new Vector3f(1.25f, 1.25f, 1.0f)));
        } else {
            matrixStack.m_166854_(MathUtils.createTransformMatrix(Vector3f.f_176763_, Vector3f.f_176763_, 0.665f));
        }
        if (options.isActive(ConfigurationToolItem.ConfigurationAction.TOGGLE_NUMBERS)) {
            DrawerRenderer.renderText(matrixStack, bufferIn, combinedOverlayIn, (Component)new TextComponent(ChatFormatting.WHITE + NumberUtils.getFormatedBigNumber(amount)), Direction.NORTH, scale);
        }
    }

    private void render1Slot(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, DrawerTile tile) {
        BigInventoryHandler inventoryHandler = (BigInventoryHandler)tile.getStorage();
        if (!inventoryHandler.getStoredStacks().get(0).getStack().m_41619_()) {
            matrixStack.m_85837_(0.5, 0.5, (double)5.0E-4f);
            ItemStack stack = inventoryHandler.getStoredStacks().get(0).getStack();
            DrawerRenderer.renderStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, stack, inventoryHandler.getStackInSlot(0).m_41613_(), 0.015f, tile.getDrawerOptions());
        }
    }

    public void render(DrawerTile tile, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (Minecraft.m_91087_().f_91074_ != null && !tile.m_58899_().m_123314_((Vec3i)Minecraft.m_91087_().f_91074_.m_20097_(), (double)FunctionalStorageClientConfig.DRAWER_RENDER_RANGE)) {
            return;
        }
        matrixStack.m_85836_();
        Direction facing = tile.getFacingDirection();
        matrixStack.m_166854_(MathUtils.createTransformMatrix(Vector3f.f_176763_, new Vector3f(0.0f, 180.0f, 0.0f), 1.0f));
        if (facing == Direction.NORTH) {
            matrixStack.m_166854_(MathUtils.createTransformMatrix(new Vector3f(-1.0f, 0.0f, 0.0f), Vector3f.f_176763_, 1.0f));
        } else if (facing == Direction.EAST) {
            matrixStack.m_166854_(MathUtils.createTransformMatrix(new Vector3f(-1.0f, 0.0f, -1.0f), new Vector3f(0.0f, -90.0f, 0.0f), 1.0f));
        } else if (facing == Direction.SOUTH) {
            matrixStack.m_166854_(MathUtils.createTransformMatrix(new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(0.0f, 180.0f, 0.0f), 1.0f));
        } else if (facing == Direction.WEST) {
            matrixStack.m_166854_(MathUtils.createTransformMatrix(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 90.0f, 0.0f), 1.0f));
        }
        matrixStack.m_85837_(0.0, 0.0, -0.03125);
        combinedLightIn = LevelRenderer.m_109541_((BlockAndTintGetter)tile.m_58904_(), (BlockPos)tile.m_58899_().m_142300_(facing));
        DrawerRenderer.renderUpgrades(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, tile);
        if (tile.getDrawerType() == FunctionalStorage.DrawerType.X_1) {
            this.render1Slot(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, tile);
        }
        if (tile.getDrawerType() == FunctionalStorage.DrawerType.X_2) {
            this.render2Slot(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, tile);
        }
        if (tile.getDrawerType() == FunctionalStorage.DrawerType.X_4) {
            this.render4Slot(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, tile);
        }
        matrixStack.m_85849_();
    }

    private void render2Slot(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, DrawerTile tile) {
        ItemStack stack;
        BigInventoryHandler inventoryHandler = (BigInventoryHandler)tile.getStorage();
        if (!inventoryHandler.getStoredStacks().get(0).getStack().m_41619_()) {
            matrixStack.m_85836_();
            matrixStack.m_166854_(MathUtils.createTransformMatrix(new Vector3f(0.5f, 0.27f, 5.0E-4f), Vector3f.f_176763_, new Vector3f(0.5f, 0.5f, 1.0f)));
            stack = inventoryHandler.getStoredStacks().get(0).getStack();
            DrawerRenderer.renderStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, stack, inventoryHandler.getStackInSlot(0).m_41613_(), 0.02f, tile.getDrawerOptions());
            matrixStack.m_85849_();
        }
        if (!inventoryHandler.getStoredStacks().get(1).getStack().m_41619_()) {
            matrixStack.m_85836_();
            matrixStack.m_166854_(MathUtils.createTransformMatrix(new Vector3f(0.5f, 0.77f, 5.0E-4f), Vector3f.f_176763_, new Vector3f(0.5f, 0.5f, 1.0f)));
            stack = inventoryHandler.getStoredStacks().get(1).getStack();
            DrawerRenderer.renderStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, stack, inventoryHandler.getStackInSlot(1).m_41613_(), 0.02f, tile.getDrawerOptions());
            matrixStack.m_85849_();
        }
    }

    private void render4Slot(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, DrawerTile tile) {
        ItemStack stack;
        BigInventoryHandler inventoryHandler = (BigInventoryHandler)tile.getStorage();
        if (!inventoryHandler.getStoredStacks().get(0).getStack().m_41619_()) {
            matrixStack.m_85836_();
            matrixStack.m_166854_(MathUtils.createTransformMatrix(new Vector3f(0.75f, 0.27f, 5.0E-4f), Vector3f.f_176763_, new Vector3f(0.5f, 0.5f, 1.0f)));
            stack = inventoryHandler.getStoredStacks().get(0).getStack();
            DrawerRenderer.renderStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, stack, inventoryHandler.getStackInSlot(0).m_41613_(), 0.02f, tile.getDrawerOptions());
            matrixStack.m_85849_();
        }
        if (!inventoryHandler.getStoredStacks().get(1).getStack().m_41619_()) {
            matrixStack.m_85836_();
            matrixStack.m_166854_(MathUtils.createTransformMatrix(new Vector3f(0.25f, 0.27f, 5.0E-4f), Vector3f.f_176763_, new Vector3f(0.5f, 0.5f, 1.0f)));
            stack = inventoryHandler.getStoredStacks().get(1).getStack();
            DrawerRenderer.renderStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, stack, inventoryHandler.getStackInSlot(1).m_41613_(), 0.02f, tile.getDrawerOptions());
            matrixStack.m_85849_();
        }
        if (!inventoryHandler.getStoredStacks().get(2).getStack().m_41619_()) {
            matrixStack.m_85836_();
            matrixStack.m_166854_(MathUtils.createTransformMatrix(new Vector3f(0.75f, 0.77f, 5.0E-4f), Vector3f.f_176763_, new Vector3f(0.5f, 0.5f, 1.0f)));
            stack = inventoryHandler.getStoredStacks().get(2).getStack();
            DrawerRenderer.renderStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, stack, inventoryHandler.getStackInSlot(2).m_41613_(), 0.02f, tile.getDrawerOptions());
            matrixStack.m_85849_();
        }
        if (!inventoryHandler.getStoredStacks().get(3).getStack().m_41619_()) {
            matrixStack.m_85836_();
            matrixStack.m_166854_(MathUtils.createTransformMatrix(new Vector3f(0.25f, 0.77f, 5.0E-4f), Vector3f.f_176763_, new Vector3f(0.5f, 0.5f, 1.0f)));
            stack = inventoryHandler.getStoredStacks().get(3).getStack();
            DrawerRenderer.renderStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, stack, inventoryHandler.getStackInSlot(3).m_41613_(), 0.02f, tile.getDrawerOptions());
            matrixStack.m_85849_();
        }
    }

    public static void renderText(PoseStack matrix, MultiBufferSource renderer, int overlayLight, Component text, Direction side, float maxScale) {
        matrix.m_85837_(0.0, -0.745, 0.0);
        float displayWidth = 1.0f;
        float displayHeight = 1.0f;
        Font font = Minecraft.m_91087_().f_91062_;
        int requiredWidth = Math.max(font.m_92852_((FormattedText)text), 1);
        Objects.requireNonNull(font);
        int requiredHeight = 9 + 2;
        float scaler = 0.4f;
        float scaleX = displayWidth / (float)requiredWidth;
        float scale = scaleX * scaler;
        if (maxScale > 0.0f) {
            scale = Math.min(scale, maxScale);
        }
        matrix.m_85841_(scale, -scale, scale);
        int realHeight = (int)Math.floor(displayHeight / scale);
        int realWidth = (int)Math.floor(displayWidth / scale);
        int offsetX = (realWidth - requiredWidth) / 2;
        int offsetY = (realHeight - requiredHeight) / 2;
        font.m_92841_(text, (float)(offsetX - realWidth / 2), (float)(3 + offsetY - realHeight / 2), overlayLight, false, matrix.m_85850_().m_85861_(), renderer, false, 0, 0xF000F0);
    }
}

